<?php
/**
* The gateway_hpp class, containing the payment processing code
* for transactions with Secure Hosted Payment Page
*
*/



include 'settings/settings.php';

$nzshpcrt_gateways[$num]['name'] = $GLOBALS['wpe_customer_name'].' '.'Payment Gateway';
$nzshpcrt_gateways[$num]['image'] = WPSC_URL . '/images/'.$GLOBALS['wpe_logo'];
$nzshpcrt_gateways[$num]['internalname'] = $GLOBALS['wpe_short_name'].'_hpp';
$nzshpcrt_gateways[$num]['function'] = 'gateway_payment_hpp';
$nzshpcrt_gateways[$num]['form'] = 'form_gateway_hpp';
$nzshpcrt_gateways[$num]['submit_function'] = 'submit_gateway_hpp';



function form_gateway_hpp() {
      
        $baseCurrencies = explode(',', $GLOBALS['wpe_currency_code']);

        $currency_options = array();
        $baseCurrencyString = "";
        for ($i=0; $i < count($baseCurrencies); $i+=2) {
             $currency_options[$baseCurrencies[$i]] = $baseCurrencies[$i+1];   
        }
        
        foreach($currency_options as $name => $code) {
                    
            $baseCurrencyString .= '<option value="' . trim($name) . '"' . (trim($name) == get_option($GLOBALS['wpe_terminal_currency1']) ? ' selected="selected"' : '') . '>' . $code . '</option>';
        }
        $output = '<tr><td>Test account?</td><td><input name="'.$GLOBALS['wpe_test_mode'].'" type="checkbox" ' . (get_option($GLOBALS['wpe_test_mode']) ? 'checked="checked"' : '') . '/></td></tr>';
        $output .= '<tr><td>Terminal ID:</td><td><input name="'.$GLOBALS['wpe_terminalid1'].'" type="text" value="' . get_option($GLOBALS['wpe_terminalid1']) . '" /></td></tr>';
        $output .= '<tr><td>Terminal Currency:</td><td><select name="'.$GLOBALS['wpe_terminal_currency1'].'">' . $baseCurrencyString . '</select></td></tr>';
        $output .= '<tr><td>Shared Secret:</td><td><input name="'.$GLOBALS['wpe_terminal_secret1'].'" type="text" value="' . get_option($GLOBALS['wpe_terminal_secret1']) . '" /></td></tr>';
        $output .= '<tr><td>Send receipt to the customer?</td><td><input name="'.$GLOBALS['wpe_send_email'].'" type="checkbox" ' . (get_option($GLOBALS['wpe_send_email']) ? 'checked="checked" ' : '') . '/></td></tr>';
        $output .= '<tr><td>Send billing address to the payment page (for AVS)?</td><td><input name="'.$GLOBALS['wpe_send_address'].'" type="checkbox" ' . (get_option($GLOBALS['wpe_send_address']) ? 'checked="checked" ' : '') . '/></td></tr>';

        return $output;
}

function submit_gateway_hpp() {
        if(isset($_POST[$GLOBALS['wpe_test_mode']])) update_option($GLOBALS['wpe_test_mode'], true);
        else update_option($GLOBALS['wpe_test_mode'], false);

        update_option($GLOBALS['wpe_terminalid1'], $_POST[$GLOBALS['wpe_terminalid1']]);
        update_option($GLOBALS['wpe_terminal_currency1'], $_POST[$GLOBALS['wpe_terminal_currency1']]);
        update_option($GLOBALS['wpe_terminal_secret1'], $_POST[$GLOBALS['wpe_terminal_secret1']]);

        if(isset($_POST[$GLOBALS['wpe_send_address']])) update_option($GLOBALS['wpe_send_address'], true);
        else update_option($GLOBALS['wpe_send_address'], false);

        if(isset($_POST[$GLOBALS['wpe_send_email']])) update_option($GLOBALS['wpe_send_email'], true);
        else update_option($GLOBALS['wpe_send_email'], false);

        return true;
}


function gateway_payment_hpp($seperator, $sessionid) {
        global $wpdb, $wpsc_cart;

        $purchase_log = $wpdb->get_row("SELECT * FROM `" . WPSC_TABLE_PURCHASE_LOGS . "` WHERE `sessionid`= " . $sessionid . " LIMIT 1", ARRAY_A);

        $usersql = "SELECT `".WPSC_TABLE_SUBMITED_FORM_DATA."`.value, `".WPSC_TABLE_CHECKOUT_FORMS."`.`name`, `".WPSC_TABLE_CHECKOUT_FORMS."`.`unique_name` FROM `".WPSC_TABLE_CHECKOUT_FORMS."` LEFT JOIN `".WPSC_TABLE_SUBMITED_FORM_DATA."` ON `".WPSC_TABLE_CHECKOUT_FORMS."`.id = `".WPSC_TABLE_SUBMITED_FORM_DATA."`.`form_id` WHERE `".WPSC_TABLE_SUBMITED_FORM_DATA."`.`log_id`=".$purchase_log['id']." ORDER BY `".WPSC_TABLE_CHECKOUT_FORMS."`.`checkout_order`";
        $userinfo = $wpdb->get_results($usersql, ARRAY_A);

        $dateTime = date('d-m-Y:H:i:s:000');

        $receiptPageURL = get_option('transact_url') . $seperator . "sessionid=" . $sessionid . "&gateway=".$GLOBALS['wpe_hppglobal']."&process=return";
        $validationURL = get_option('transact_url') . $seperator . "&gateway=".$GLOBALS['wpe_hppglobal']."&process=validate";

        $data = array();
        $data['TERMINALID']             = get_option($GLOBALS['wpe_terminalid1']);
        $data['ORDERID']                = $purchase_log['id'];
        $data['CURRENCY']               = get_option($GLOBALS['wpe_terminal_currency1']);
        $data['AMOUNT']                 = number_format( $wpsc_cart->total_price ,2, '.', '');

        if(get_option($GLOBALS['wpe_send_email']) || get_option($GLOBALS['wpe_send_address'])) {
                $form_fields = $wpdb->get_results("SELECT `id`,`unique_name` FROM `".WPSC_TABLE_CHECKOUT_FORMS."` WHERE `active` = '1'",ARRAY_A);
                foreach((array)$form_fields as $field) {
                        if(get_option($GLOBALS['wpe_send_email']) && $field["unique_name"] == "billingemail") {
                                $data['EMAIL'] = $_REQUEST['collected_data'][$field['id']];
                        }
                        if(get_option($GLOBALS['wpe_send_address'])) {
                                if($field["unique_name"] == "billingaddress") $data['ADDRESS1'] = $_REQUEST['collected_data'][$field['id']];
                                if($field["unique_name"] == "billingcity") $data['ADDRESS2'] = $_REQUEST['collected_data'][$field['id']];
                                if($field["unique_name"] == "billingpostcode") $data['POSTCODE'] = $_REQUEST['collected_data'][$field['id']];
                        }
                }
        }

        $data['DATETIME']               = $dateTime;
        $data['RECEIPTPAGEURL']         = $receiptPageURL;
        $data['VALIDATIONURL']          = $validationURL;
        $data['HASH']                   = md5(get_option($GLOBALS['wpe_terminalid1']) . $purchase_log['id'] . number_format( $wpsc_cart->total_price ,2, '.', '') . $dateTime . $receiptPageURL . 		$validationURL . get_option($GLOBALS['wpe_terminal_secret1']));
        $data['WORDPRESSSESSIONID']     = $sessionid;

	    if(get_option($GLOBALS['wpe_test_mode']))
            $gatewayURL = "https://testpayments.nuvei.com/merchant/paymentpage";
	    else
            $gatewayURL = "https://payments.nuvei.com/merchant/paymentpage";

        $hppform = $GLOBALS['wpe_hppglobal'].'_form';
        echo "<div style='display: none'>\n<form id='$hppform' action='$gatewayURL' method='post'>\n";
        foreach($data as $key => $val) echo "<input type='hidden' name='$key' value='$val' />\n";
        echo "<input type='submit' value='Pay' /></form>\n</div>\n<script language='javascript' type='text/javascript'>document.getElementById('$hppform').submit();</script>";

        exit();
}

function catch_payment_gateway_hpp() {
        if(isset($_REQUEST['gateway']) && $_REQUEST['gateway'] == $GLOBALS['wpe_hppglobal'] && isset($_REQUEST['process']) && $_REQUEST['process'] == 'return' && isset($_REQUEST['WORDPRESSSESSIONID']) && $_REQUEST['WORDPRESSSESSIONID'] != "") {
                if($_REQUEST['RESPONSECODE'] == 'A') {
                        if(strstr(get_option('transact_url'), "?")) $next_url = get_option('transact_url') . "&sessionid=" . $_REQUEST['WORDPRESSSESSIONID'];
                        else $next_url = get_option('transact_url') . "?sessionid=" . $_REQUEST['WORDPRESSSESSIONID'];
                }
                else {
                        if(strstr(get_option('transact_url'), "?")) $next_url = get_option('transact_url')."&act=error";
                        else $next_url = get_option('transact_url')."?act=error";
                }

                header("Location: " . $next_url);
                exit();
        }
}

function catch_payment_gateway_validation() {
        global $wpdb;
        if(isset($_REQUEST['gateway']) && $_REQUEST['gateway'] == $GLOBALS['wpe_hppglobal'] && isset($_REQUEST['process']) && $_REQUEST['process'] == 'validate') {
                $terminalId = get_option($GLOBALS['wpe_terminalid1']);
                $expectedResponseHash = md5($terminalId . $_REQUEST['ORDERID'] . $_REQUEST['AMOUNT'] . $_REQUEST['DATETIME'] . $_REQUEST['RESPONSECODE'] . $_REQUEST['RESPONSETEXT'] . get_option($GLOBALS['wpe_terminal_secret1']));

                if($expectedResponseHash != $_REQUEST['HASH']) {
                        $wpdb->query("UPDATE `" . WPSC_TABLE_PURCHASE_LOGS . "` SET `processed` = '1' WHERE `id` = " . $_REQUEST['ORDERID']);
                        die("Hash mismatch for Order ID ".$_REQUEST['ORDERID'].", expected: ".$expectedResponseHash);
                } else {
                        switch($_REQUEST['RESPONSECODE']) {
                                case 'A':       $wpdb->query("UPDATE `" . WPSC_TABLE_PURCHASE_LOGS . "` SET `processed` = '3' WHERE `id` = " . $_REQUEST['ORDERID']);
                                                break;
                                default:        $wpdb->query("UPDATE `" . WPSC_TABLE_PURCHASE_LOGS . "` SET `processed` = '6' WHERE `id` = " . $_REQUEST['ORDERID']);
                        }
                        die("OK");
                }
        }
}

add_action('init', 'catch_payment_gateway_hpp');
add_action('init', 'catch_payment_gateway_validation');

?>
                                                         
