jQuery( function( $ ) {
	'use strict';

	/**
	 * Object to handle Nuvei admin functions.
	 */
	var wc_nuvei_admin = {
		isTestMode: function() {
			return $( '#woocommerce_nuvei_testmode' ).is( ':checked' );
		},

		getSecretKey: function() {
			if ( wc_nuvei_admin.isTestMode() ) {
				return $( '#woocommerce_nuvei_test_secret_key' ).val();
			} else {
				return $( '#woocommerce_nuvei_secret_key' ).val();
			}
		},

		/**
		 * Initialize.
		 */
		init: function() {
			$( document.body ).on( 'change', '#woocommerce_nuvei_testmode', function() {
				var test_secret_key = $( '#woocommerce_nuvei_test_secret_key' ).parents( 'tr' ).eq( 0 ),
					test_publishable_key = $( '#woocommerce_nuvei_test_publishable_key' ).parents( 'tr' ).eq( 0 ),
					test_currency = $( '#woocommerce_nuvei_test_currency' ).parents( 'tr' ).eq( 0 ),
					test_multicurrency = $( '#woocommerce_nuvei_test_multicurrency' ).parents( 'tr' ).eq( 0 ),
					test_secret_key2 = $( '#woocommerce_nuvei_test_secret_key2' ).parents( 'tr' ).eq( 0 ),
					test_publishable_key2 = $( '#woocommerce_nuvei_test_publishable_key2' ).parents( 'tr' ).eq( 0 ),
					test_currency2 = $( '#woocommerce_nuvei_test_currency2' ).parents( 'tr' ).eq( 0 ),
					test_multicurrency2 = $( '#woocommerce_nuvei_test_multicurrency2' ).parents( 'tr' ).eq( 0 ),
					test_secret_key3 = $( '#woocommerce_nuvei_test_secret_key3' ).parents( 'tr' ).eq( 0 ),
					test_publishable_key3 = $( '#woocommerce_nuvei_test_publishable_key3' ).parents( 'tr' ).eq( 0 ),
					test_currency3 = $( '#woocommerce_nuvei_test_currency3' ).parents( 'tr' ).eq( 0 ),
					test_multicurrency3 = $( '#woocommerce_nuvei_test_multicurrency3' ).parents( 'tr' ).eq( 0 ),

					live_secret_key = $( '#woocommerce_nuvei_secret_key' ).parents( 'tr' ).eq( 0 ),
					live_publishable_key = $( '#woocommerce_nuvei_publishable_key' ).parents( 'tr' ).eq( 0 ),
					live_currency = $( '#woocommerce_nuvei_live_currency' ).parents( 'tr' ).eq( 0 ),
					live_multicurrency = $( '#woocommerce_nuvei_live_multicurrency' ).parents( 'tr' ).eq( 0 ),
					live_secret_key2 = $( '#woocommerce_nuvei_secret_key2' ).parents( 'tr' ).eq( 0 ),
					live_publishable_key2 = $( '#woocommerce_nuvei_publishable_key2' ).parents( 'tr' ).eq( 0 ),
					live_currency2 = $( '#woocommerce_nuvei_live_currency2' ).parents( 'tr' ).eq( 0 ),
					live_multicurrency2 = $( '#woocommerce_nuvei_live_multicurrency2' ).parents( 'tr' ).eq( 0 ),
					live_secret_key3 = $( '#woocommerce_nuvei_secret_key3' ).parents( 'tr' ).eq( 0 ),
					live_publishable_key3 = $( '#woocommerce_nuvei_publishable_key3' ).parents( 'tr' ).eq( 0 ),
					live_currency3 = $( '#woocommerce_nuvei_live_currency3' ).parents( 'tr' ).eq( 0 ),
					live_multicurrency3 = $( '#woocommerce_nuvei_live_multicurrency3' ).parents( 'tr' ).eq( 0 ),

					title = $( '#woocommerce_nuvei_title' ).parents( 'tr' ).eq( 0 ),
					description = $( '#woocommerce_nuvei_description' ).parents( 'tr' ).eq( 0 );

				if ( $( this ).is( ':checked' ) ) {
					test_secret_key.show();
					test_publishable_key.show();
					test_currency.show();
					test_multicurrency.show();
					test_secret_key2.show();
					test_publishable_key2.show();
					test_currency2.show();
					test_multicurrency2.show();
					test_secret_key3.show();
					test_publishable_key3.show();
					test_currency3.show();
					test_multicurrency3.show();

					live_secret_key.hide();
					live_publishable_key.hide();
					live_currency.hide();
					live_multicurrency.hide();
					live_secret_key2.hide();
					live_publishable_key2.hide();
					live_currency2.hide();
					live_multicurrency2.hide();
					live_secret_key3.hide();
					live_publishable_key3.hide();
					live_currency3.hide();
					live_multicurrency3.hide();
				} else {
					test_secret_key.hide();
					test_publishable_key.hide();
					test_currency.hide();
					test_multicurrency.hide();
					test_secret_key2.hide();
					test_publishable_key2.hide();
					test_currency2.hide();
					test_multicurrency2.hide();
					test_secret_key3.hide();
					test_publishable_key3.hide();
					test_currency3.hide();
					test_multicurrency3.hide();

					live_secret_key.show();
					live_publishable_key.show();
					live_currency.show();
					live_multicurrency.show();
					live_secret_key2.show();
					live_publishable_key2.show();
					live_currency2.show();
					live_multicurrency2.show();
					live_secret_key3.show();
					live_publishable_key3.show();
					live_currency3.show();
					live_multicurrency3.show();
				}

				title.hide();
				description.hide();
			} );

			$( '#woocommerce_nuvei_testmode' ).change();

			// Validate the keys to make sure it is matching test with test field.
			$( '#woocommerce_nuvei_secret_key, #woocommerce_nuvei_publishable_key' ).on( 'input', function() {
				var value = $( this ).val();

				if ( value.indexOf( '_test_' ) >= 0 ) {
					$( this ).css( 'border-color', 'red' ).after( '<span class="description nuvei-error-description" style="color:red; display:block;">' + wc_nuvei_admin_params.localized_messages.not_valid_live_key_msg + '</span>' );
				} else {
					$( this ).css( 'border-color', '' );
					$( '.nuvei-error-description', $( this ).parent() ).remove();
				}
			}).trigger( 'input' );

			// Validate the keys to make sure it is matching live with live field.
			$( '#woocommerce_nuvei_test_secret_key, #woocommerce_nuvei_test_publishable_key' ).on( 'input', function() {
				var value = $( this ).val();

				if ( value.indexOf( '_live_' ) >= 0 ) {
					$( this ).css( 'border-color', 'red' ).after( '<span class="description nuvei-error-description" style="color:red; display:block;">' + wc_nuvei_admin_params.localized_messages.not_valid_test_key_msg + '</span>' );
				} else {
					$( this ).css( 'border-color', '' );
					$( '.nuvei-error-description', $( this ).parent() ).remove();
				}
			}).trigger( 'input' );

		}
	};

	wc_nuvei_admin.init();
});
