/* global wc_worldnet_params */

jQuery( function( $ ) {
	'use strict';


	/**
	 * Object to handle Worldnet payment forms.
	 */
	var wc_worldnet_form = {

		/**
		 * Initialize event handlers and UI state.
		 */
		init: function() {
			this.token = '';

			// checkout page
			if ( $( 'form.woocommerce-checkout' ).length ) {
				this.form = $( 'form.woocommerce-checkout' );
			}

			$( 'form.woocommerce-checkout' )
				.on(
					'checkout_place_order_worldnet',
					this.onSubmit
				);

			// pay order page
			if ( $( 'form#order_review' ).length ) {
				this.form = $( 'form#order_review' );
			}

			$( 'form#order_review' )
				.on(
					'submit',
					this.onSubmit
				);

			// add payment method page
			if ( $( 'form#add_payment_method' ).length ) {
				this.form = $( 'form#add_payment_method' );
			}

			$( 'form#add_payment_method' )
				.on(
					'submit',
					this.onSubmit
				);

			$( document )
				.on(
					'change',
					'#wc-worldnet-cc-form :input',
					this.onCCFormChange
				)
				.on(
					'worldnetError',
					this.onError
				)
				.on(
					'checkout_error',
					this.clearToken
				);


            $( this.form )
            // We need to bind directly to the click (and not checkout_place_order_worldnet) to avoid popup blockers
            // especially on mobile devices (like on Chrome for iOS) from blocking WorldnetCheckout.open from opening a tab
                .on( 'click', '#place_order', this.onSubmit )

                // WooCommerce lets us return a false on checkout_place_order_{gateway} to keep the form from submitting
                .on( 'submit checkout_place_order_worldnet' );
		},

		isWorldnetChosen: function() {
			return $( '#payment_method_worldnet' ).is( ':checked' ) && ( ! $( 'input[name="wc-worldnet-payment-token"]:checked' ).length || 'new' === $( 'input[name="wc-worldnet-payment-token"]:checked' ).val() );
		},

		hasToken: function() {
			return wc_worldnet_form.token.length;
		},

		block: function() {
			wc_worldnet_form.form.block({
				message: null,
				overlayCSS: {
					background: '#fff',
					opacity: 0.6
				}
			});
		},

		unblock: function() {
			wc_worldnet_form.form.unblock();
		},

		onError: function( e, responseObject ) {
			var message = responseObject.response.error.message;

			// Customers do not need to know the specifics of the below type of errors
			// therefore return a generic localizable error message.
			if ( 
				'invalid_request_error' === responseObject.response.error.type ||
				'api_connection_error'  === responseObject.response.error.type ||
				'api_error'             === responseObject.response.error.type ||
				'authentication_error'  === responseObject.response.error.type ||
				'rate_limit_error'      === responseObject.response.error.type
			) {
				message = wc_worldnet_params.invalid_request_error;
			}

			if ( 'card_error' === responseObject.response.error.type && wc_worldnet_params.hasOwnProperty( responseObject.response.error.code ) ) {
				message = wc_worldnet_params[ responseObject.response.error.code ];
			}

			$( '.wc-worldnet-error, .worldnet_token' ).remove();
			$( '#worldnet-card-number' ).closest( 'p' ).before( '<ul class="woocommerce_error woocommerce-error wc-worldnet-error"><li>' + message + '</li></ul>' );
			wc_worldnet_form.unblock();
		},

		onSubmit: function( e ) {
			if ( wc_worldnet_form.isWorldnetChosen() && ! wc_worldnet_form.hasToken() ) {
				e.preventDefault();
				wc_worldnet_form.block();


				var $form = wc_worldnet_form.form,
					$data = $('#worldnet-payment-data');




				var expires    = $( '#worldnet-card-expiry' ).payment( 'cardExpiryVal' );
				var exp_month  = (parseInt( expires.month, 10 )<10?'0':'')+parseInt( expires.month, 10 );
				var exp_year = parseInt( expires.year, 10 )%100;
				var expCheck = new Date();
				expCheck = parseInt(String(expCheck.getFullYear()%100)+String(expCheck.getMonth()+1));
				var ccExp = parseInt(String(exp_year)+String(exp_month));

				$form.append('<input type="hidden" name="card-name" value="' + $('#worldnet-card-name').val() + '"/>');
				$form.append('<input type="hidden" name="card-number" value="' + $('#worldnet-card-number').val() + '"/>');
				$form.append('<input type="hidden" name="card-expiry" value="' + exp_month+exp_year + '"/>');
				$form.append('<input type="hidden" name="cvc" value="' + $('#worldnet-card-cvc').val() + '"/>');

				$form.append('<input type="hidden" name="terminal-id" value="' + $data.data('terminal-id') + '"/>');
				$form.append('<input type="hidden" name="currency" value="' + $data.data('currency') + '"/>');
				$form.append('<input type="hidden" name="amount" value="' + $data.data('amount') + '"/>');

				//token generation
				var token = '';
				var charset = "abcdefghijklmnopqrstuvwxyz0123456789";
				for( var i=0; i < 64; i++ )
					token += charset.charAt(Math.floor(Math.random() * charset.length));

				var ccValid = false;
				$('#worldnet-card-number').validateCreditCard(function(result) {
					ccValid = result.valid;
				});

				if($('#worldnet-card-name').val() && ccValid && ($('#worldnet-card-cvc').val().length>=3 && $('#worldnet-card-cvc').val().length<=4) && (exp_month && exp_year && ccExp>=expCheck)) {
					wc_worldnet_form.token = token;
					$form.submit();
				}
				else {
					wc_worldnet_form.unblock();

					if(!$('#worldnet-card-name').val()) {
						$('#worldnet-card-name').attr('style', 'border-color: red');
						$('#worldnet-card-name').addClass('input-invalid');
					}
					else {
						$('#worldnet-card-name').attr('style', 'border-color: rgb(234, 234, 234)');
						$('#worldnet-card-name').removeClass('input-invalid');
					}

					if(!ccValid) {
						$('#worldnet-card-number').attr('style', 'border-color: red');
						$('#worldnet-card-number').addClass('input-invalid');
					}
					else {
						$('#worldnet-card-number').attr('style', 'border-color: rgb(234, 234, 234)');
						$('#worldnet-card-number').removeClass('input-invalid');
					}

					if($('#worldnet-card-cvc').val().length<3 || $('#worldnet-card-cvc').val().length>4) {
						$('#worldnet-card-cvc').attr('style', 'border-color: red');
						$('#worldnet-card-cvc').addClass('input-invalid');
					}
					else {
						$('#worldnet-card-cvc').attr('style', 'border-color: rgb(234, 234, 234)');
						$('#worldnet-card-cvc').removeClass('input-invalid');
					}

					if((!exp_month || !exp_year || ccExp<expCheck)) {
						$('#worldnet-card-expiry').attr('style', 'border-color: red');
						$('#worldnet-card-expiry').addClass('input-invalid');
					}
					else {
						$('#worldnet-card-expiry').attr('style', 'border-color: rgb(234, 234, 234)');
						$('#worldnet-card-expiry').removeClass('input-invalid');
					}
				}

				return false;
			}
		},

		onCCFormChange: function() {
			$( '.wc-worldnet-error, .worldnet_token' ).remove();
		},

		clearToken: function() {
			$( '.worldnet_token' ).remove();
		}
	};

	wc_worldnet_form.init();
} );
