jQuery( function( $ ) {
	'use strict';
	
	/**
	 * Object to handle Worldnet payment forms.
	 */
	var wc_worldnet_form = {

		/**
		 * Initialize e handlers and UI state.
		 */
		init: function( form ) {
			this.form          = form;
			this.worldnet_submit = false;

			$( this.form )
				// We need to bind directly to the click (and not checkout_place_order_worldnet) to avoid popup blockers
				// especially on mobile devices (like on Chrome for iOS) from blocking WorldnetCheckout.open from opening a tab
				.on( 'click', '#place_order', this.onSubmit )

				// WooCommerce lets us return a false on checkout_place_order_{gateway} to keep the form from submitting
				.on( 'submit checkout_place_order_worldnet' );

			$( document.body ).on( 'checkout_error', this.resetModal );
		},

		isWorldnetChosen: function() {
			return $( '#payment_method_worldnet' ).is( ':checked' ) && ( ! $( 'input[name="wc-worldnet-payment-token"]:checked' ).length || 'new' === $( 'input[name="wc-worldnet-payment-token"]:checked' ).val() );
		},

		isWorldnetModalNeeded: function( e ) {
			var token = wc_worldnet_form.form.find( 'input.worldnet_token' ),
				$required_inputs;

			// If this is a worldnet submission (after modal) and token exists, allow submit.
			if ( wc_worldnet_form.worldnet_submit && token ) {
				return false;
			}

			// Don't affect submission if modal is not needed.
			if ( ! wc_worldnet_form.isWorldnetChosen() ) {
				return false;
			}

			// Don't open modal if required fields are not complete
			if ( $( 'input#terms' ).length === 1 && $( 'input#terms:checked' ).length === 0 ) {
				return false;
			}

			if ( $( '#createaccount' ).is( ':checked' ) && $( '#account_password' ).length && $( '#account_password' ).val() === '' ) {
				return false;
			}

			// check to see if we need to validate shipping address
			if ( $( '#ship-to-different-address-checkbox' ).is( ':checked' ) ) {
				$required_inputs = $( '.woocommerce-billing-fields .validate-required, .woocommerce-shipping-fields .validate-required' );
			} else {
				$required_inputs = $( '.woocommerce-billing-fields .validate-required' );
			}

			if ( $required_inputs.length ) {
				var required_error = false;

				$required_inputs.each( function() {
					if ( $( this ).find( 'input.input-text, select' ).not( $( '#account_password, #account_username' ) ).val() === '' ) {
						required_error = true;
					}

					var emailField = $( this ).find( '#billing_email' );

					if ( emailField.length ) {
						var re = /^([a-zA-Z0-9_\.\-\+])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;

						if ( ! re.test( emailField.val() ) ) {
							required_error = true;
						}
					}
				});

				if ( required_error ) {
					return false;
				}
			}

			return true;
		},

		block: function() {
			wc_worldnet_form.form.block({
				message: null,
				overlayCSS: {
					background: '#fff',
					opacity: 0.6
				}
			});
		},

		unblock: function() {
			wc_worldnet_form.form.unblock();
		},

		onClose: function() {
			wc_worldnet_form.unblock();
		},

		onSubmit: function( e ) {
			var $form = wc_worldnet_form.form,
				$data = $( '#worldnet-payment-data' ),
				token = $form.find( 'input.c' );

			$form.append( '<input type="hidden" name="terminal-id" value="' + $data.data('terminal-id') + '"/>' );
			$form.append( '<input type="hidden" name="currency" value="' + $data.data('currency') + '"/>' );
			$form.append( '<input type="hidden" name="amount" value="' + $data.data('amount') + '"/>' );

			$form.submit();

			return false;
		},

		resetModal: function() {
			wc_worldnet_form.form.find( 'input.worldnet_token' ).remove();
			wc_worldnet_form.worldnet_submit = false;
		}
	};

	wc_worldnet_form.init( $( "form.checkout, form#order_review, form#add_payment_method" ) );
} );
