jQuery( function( $ ) {
	'use strict';

	/**
	 * Object to handle Worldnet admin functions.
	 */
	var wc_worldnet_admin = {
		isTestMode: function() {
			return $( '#woocommerce_worldnet_testmode' ).is( ':checked' );
		},

		getSecretKey: function() {
			if ( wc_worldnet_admin.isTestMode() ) {
				return $( '#woocommerce_worldnet_test_secret_key' ).val();
			} else {
				return $( '#woocommerce_worldnet_secret_key' ).val();
			}
		},

		/**
		 * Initialize.
		 */
		init: function() {
			$( document.body ).on( 'change', '#woocommerce_worldnet_testmode', function() {
				var test_secret_key = $( '#woocommerce_worldnet_test_secret_key' ).parents( 'tr' ).eq( 0 ),
					test_publishable_key = $( '#woocommerce_worldnet_test_publishable_key' ).parents( 'tr' ).eq( 0 ),
					test_currency = $( '#woocommerce_worldnet_test_currency' ).parents( 'tr' ).eq( 0 ),
					test_multicurrency = $( '#woocommerce_worldnet_test_multicurrency' ).parents( 'tr' ).eq( 0 ),
					test_secret_key2 = $( '#woocommerce_worldnet_test_secret_key2' ).parents( 'tr' ).eq( 0 ),
					test_publishable_key2 = $( '#woocommerce_worldnet_test_publishable_key2' ).parents( 'tr' ).eq( 0 ),
					test_currency2 = $( '#woocommerce_worldnet_test_currency2' ).parents( 'tr' ).eq( 0 ),
					test_multicurrency2 = $( '#woocommerce_worldnet_test_multicurrency2' ).parents( 'tr' ).eq( 0 ),
					test_secret_key3 = $( '#woocommerce_worldnet_test_secret_key3' ).parents( 'tr' ).eq( 0 ),
					test_publishable_key3 = $( '#woocommerce_worldnet_test_publishable_key3' ).parents( 'tr' ).eq( 0 ),
					test_currency3 = $( '#woocommerce_worldnet_test_currency3' ).parents( 'tr' ).eq( 0 ),
					test_multicurrency3 = $( '#woocommerce_worldnet_test_multicurrency3' ).parents( 'tr' ).eq( 0 ),

					live_secret_key = $( '#woocommerce_worldnet_secret_key' ).parents( 'tr' ).eq( 0 ),
					live_publishable_key = $( '#woocommerce_worldnet_publishable_key' ).parents( 'tr' ).eq( 0 ),
					live_currency = $( '#woocommerce_worldnet_live_currency' ).parents( 'tr' ).eq( 0 ),
					live_multicurrency = $( '#woocommerce_worldnet_live_multicurrency' ).parents( 'tr' ).eq( 0 ),
					live_secret_key2 = $( '#woocommerce_worldnet_secret_key2' ).parents( 'tr' ).eq( 0 ),
					live_publishable_key2 = $( '#woocommerce_worldnet_publishable_key2' ).parents( 'tr' ).eq( 0 ),
					live_currency2 = $( '#woocommerce_worldnet_live_currency2' ).parents( 'tr' ).eq( 0 ),
					live_multicurrency2 = $( '#woocommerce_worldnet_live_multicurrency2' ).parents( 'tr' ).eq( 0 ),
					live_secret_key3 = $( '#woocommerce_worldnet_secret_key3' ).parents( 'tr' ).eq( 0 ),
					live_publishable_key3 = $( '#woocommerce_worldnet_publishable_key3' ).parents( 'tr' ).eq( 0 ),
					live_currency3 = $( '#woocommerce_worldnet_live_currency3' ).parents( 'tr' ).eq( 0 ),
					live_multicurrency3 = $( '#woocommerce_worldnet_live_multicurrency3' ).parents( 'tr' ).eq( 0 ),

					title = $( '#woocommerce_worldnet_title' ).parents( 'tr' ).eq( 0 ),
					description = $( '#woocommerce_worldnet_description' ).parents( 'tr' ).eq( 0 );

				if ( $( this ).is( ':checked' ) ) {
					test_secret_key.show();
					test_publishable_key.show();
					test_currency.show();
					test_multicurrency.show();
					test_secret_key2.show();
					test_publishable_key2.show();
					test_currency2.show();
					test_multicurrency2.show();
					test_secret_key3.show();
					test_publishable_key3.show();
					test_currency3.show();
					test_multicurrency3.show();

					live_secret_key.hide();
					live_publishable_key.hide();
					live_currency.hide();
					live_multicurrency.hide();
					live_secret_key2.hide();
					live_publishable_key2.hide();
					live_currency2.hide();
					live_multicurrency2.hide();
					live_secret_key3.hide();
					live_publishable_key3.hide();
					live_currency3.hide();
					live_multicurrency3.hide();
				} else {
					test_secret_key.hide();
					test_publishable_key.hide();
					test_currency.hide();
					test_multicurrency.hide();
					test_secret_key2.hide();
					test_publishable_key2.hide();
					test_currency2.hide();
					test_multicurrency2.hide();
					test_secret_key3.hide();
					test_publishable_key3.hide();
					test_currency3.hide();
					test_multicurrency3.hide();

					live_secret_key.show();
					live_publishable_key.show();
					live_currency.show();
					live_multicurrency.show();
					live_secret_key2.show();
					live_publishable_key2.show();
					live_currency2.show();
					live_multicurrency2.show();
					live_secret_key3.show();
					live_publishable_key3.show();
					live_currency3.show();
					live_multicurrency3.show();
				}

				title.hide();
				description.hide();
			} );

			$( '#woocommerce_worldnet_testmode' ).change();

			// Validate the keys to make sure it is matching test with test field.
			$( '#woocommerce_worldnet_secret_key, #woocommerce_worldnet_publishable_key' ).on( 'input', function() {
				var value = $( this ).val();

				if ( value.indexOf( '_test_' ) >= 0 ) {
					$( this ).css( 'border-color', 'red' ).after( '<span class="description worldnet-error-description" style="color:red; display:block;">' + wc_worldnet_admin_params.localized_messages.not_valid_live_key_msg + '</span>' );
				} else {
					$( this ).css( 'border-color', '' );
					$( '.worldnet-error-description', $( this ).parent() ).remove();
				}
			}).trigger( 'input' );

			// Validate the keys to make sure it is matching live with live field.
			$( '#woocommerce_worldnet_test_secret_key, #woocommerce_worldnet_test_publishable_key' ).on( 'input', function() {
				var value = $( this ).val();

				if ( value.indexOf( '_live_' ) >= 0 ) {
					$( this ).css( 'border-color', 'red' ).after( '<span class="description worldnet-error-description" style="color:red; display:block;">' + wc_worldnet_admin_params.localized_messages.not_valid_test_key_msg + '</span>' );
				} else {
					$( this ).css( 'border-color', '' );
					$( '.worldnet-error-description', $( this ).parent() ).remove();
				}
			}).trigger( 'input' );

		}
	};

	wc_worldnet_admin.init();
});
