<?php 

class ControllerExtensionPaymentNuvei extends Controller {
	private $error = array(); 
	
	public function index() {
		$this->load->language('extension/payment/nuvei');
		
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('setting/setting');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && ($this->validate())) {
			$this->model_setting_setting->editSetting('payment_nuvei', $this->request->post);				
			$this->session->data['success'] = $this->language->get('text_success');
			$this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true));
		}
        
        $hpp_currency1 = $this->language->get('text_terminalcur').'1' ;
        $hpp_currency2 = $this->language->get('text_terminalcur').'2' ;
        $hpp_currency3 = $this->language->get('text_terminalcur').'3' ;
        
        $hpp_terminal1 = $this->language->get('text_terminalid').'1';
        $hpp_terminal2 = $this->language->get('text_terminalid').'2';
        $hpp_terminal3 = $this->language->get('text_terminalid').'3';
        
        $hpp_secret1 = $this->language->get('text_terminalsecret').'1';
        $hpp_secret2 = $this->language->get('text_terminalsecret').'2';
        $hpp_secret3 = $this->language->get('text_terminalsecret').'3';
        
        $hpp_status       = $this->language->get('text_hppstatus');
        $hpp_terminaltest = $this->language->get('text_terminaltest');
        
        $hpp_send_receipt = $this->language->get('text_send_receipt');
        $hpp_success_id   = $this->language->get('text_status_success');
        $hpp_declined_id  = $this->language->get('text_status_declined');
        $hpp_failed_id    = $this->language->get('text_status_failed');
        $hpp_sort_order   = $this->language->get('text_sort_order');

		// Check for errors
 		if (isset($this->error['warning'])) $data['error_warning'] = $this->error['warning'];
		else $data['error_warning'] = '';

		if (isset($this->error['terminaltest'])) $data['error_terminaltest'] = $this->error['terminaltest'];
		else $data['error_terminaltest'] = '';
		
		if (isset($this->error['currency1'])) $data['error_currency1'] = $this->error['currency1'];
		else $data['error_currency1'] = '';

  		if (isset($this->error['terminal1'])) $data['error_terminal1'] = $this->error['terminal1'];
		else $data['error_terminal1'] = '';

 		if (isset($this->error['secret1'])) $data['error_secret1'] = $this->error['secret1'];
		else $data['error_secret1'] = '';


		// Set Breadcumbs
  		$data['breadcrumbs'] = array();

   		$data['breadcrumbs'][] = array(
				'href'      => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true),
	       		'text'      => $this->language->get('text_home')
   		);

   		$data['breadcrumbs'][] = array(
				'href'      => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'], true),
	       		'text'      => $this->language->get('text_payment')
   		);

   		$data['breadcrumbs'][] = array(
				'href'      => $this->url->link('extension/payment/nuvei', 'user_token=' . $this->session->data['user_token'], true),
	       		'text'      => $this->language->get('heading_title')
   		);
        
        // Set actions URL
        $data['action'] = $this->url->link('extension/payment/nuvei', 'user_token=' . $this->session->data['user_token'], true);
		$data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true);

		// Load Variables Terminal 1
		if (isset($this->request->post[$hpp_currency1])) $data[$hpp_currency1] = $this->request->post[$hpp_currency1];
		else $data[$hpp_currency1] = $this->config->get($hpp_currency1);

		if (isset($this->request->post[$hpp_terminal1])) $data[$hpp_terminal1] = $this->request->post[$hpp_terminal1];
		else $data[$hpp_terminal1] = $this->config->get($hpp_terminal1);

		if (isset($this->request->post[$hpp_secret1])) $data[$hpp_secret1] = $this->request->post[$hpp_secret1];
		else $data[$hpp_secret1] = $this->config->get($hpp_secret1);

		// Load Variables Terminal 2
		if (isset($this->request->post[$hpp_currency2])) $data[$hpp_currency2] = $this->request->post[$hpp_currency2];
		else $data[$hpp_currency2] = $this->config->get($hpp_currency2);

		if (isset($this->request->post[$hpp_terminal2])) $data[$hpp_terminal2] = $this->request->post[$hpp_terminal2];
		else $data[$hpp_terminal2] = $this->config->get($hpp_terminal2);
		
		if (isset($this->request->post[$hpp_secret2])) $data[$hpp_secret2] = $this->request->post[$hpp_secret2];
		else $data[$hpp_secret2] = $this->config->get($hpp_secret2);

		// Load Variables Terminal 3
		if (isset($this->request->post[$hpp_currency3])) $data[$hpp_currency3] = $this->request->post[$hpp_currency3];
		else $data[$hpp_currency3] = $this->config->get($hpp_currency3);

		if (isset($this->request->post[$hpp_terminal3])) $data[$hpp_terminal3] = $this->request->post[$hpp_terminal3];
		else $data[$hpp_terminal3] = $this->config->get($hpp_terminal3);

		if (isset($this->request->post[$hpp_secret3])) $data[$hpp_secret3] = $this->request->post[$hpp_secret3];
		else $data[$hpp_secret3] = $this->config->get($hpp_secret3);

		// Load General Variables
		if (isset($this->request->post[$hpp_status])) $data[$hpp_status] = $this->request->post[$hpp_status];
		else $data[$hpp_status] = $this->config->get($hpp_status);

		if (isset($this->request->post[$hpp_terminaltest])) $data[$hpp_terminaltest] = $this->request->post[$hpp_terminaltest];
		else $data[$hpp_terminaltest] = $this->config->get($hpp_terminaltest);

		if (isset($this->request->post[$hpp_success_id])) $data[$hpp_success_id] = $this->request->post[$hpp_success_id];
		else $data[$hpp_success_id] = $this->config->get($hpp_success_id);

		if (isset($this->request->post[$hpp_declined_id])) $data[$hpp_declined_id] = $this->request->post[$hpp_declined_id];
		else $data[$hpp_declined_id] = $this->config->get($hpp_declined_id);

		if (isset($this->request->post[$hpp_failed_id])) $data[$hpp_failed_id] = $this->request->post[$hpp_failed_id];
		else $data[$hpp_failed_id] = $this->config->get($hpp_failed_id);

		$this->load->model('localisation/order_status');
		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		if (isset($this->request->post[$hpp_send_receipt])) $data[$hpp_send_receipt] = $this->request->post[$hpp_send_receipt];
		else $data[$hpp_send_receipt] = $this->config->get($hpp_send_receipt);

		if (isset($this->request->post[$hpp_sort_order])) $data[$hpp_sort_order] = $this->request->post[$hpp_sort_order];
		else $data[$hpp_sort_order] = $this->config->get($hpp_sort_order);

		// Load HTML sections
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/payment/nuvei', $data));
	}

	private function validate() {
		if (!$this->user->hasPermission('modify', 'extension/payment/nuvei')) $this->error['warning'] = $this->language->get('error_permission');
		
		if (!isset($this->request->post[$this->language->get('text_terminaltest')])) $this->error['terminaltest'] = $this->language->get('error_terminaltest');
		
		if (!$this->request->post[$this->language->get('text_terminalcur').'1']) $this->error['currency1'] = $this->language->get('error_currency1');
		if (!$this->request->post[$this->language->get('text_terminalid').'1']) $this->error['terminal1'] = $this->language->get('error_terminal1');
		if (!$this->request->post[$this->language->get('text_terminalsecret').'1']) $this->error['secret1'] = $this->language->get('error_secret1');
		
		if (!$this->error) return TRUE;
		else return FALSE;
	}
}
?>
