<?php
namespace Nuvei\Subscription\Setup;

use Magento\Framework\Setup\UpgradeSchemaInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;

/**
 * @codeCoverageIgnore
 */
class UpgradeSchema implements UpgradeSchemaInterface
{
    /**
     * {@inheritdoc}
     *
     * @SuppressWarnings(PHPMD.ExcessiveMethodLength)
     */
    public function upgrade( SchemaSetupInterface $setup, ModuleContextInterface $context ) {
        $installer = $setup;
        $installer->startSetup();

        if(version_compare($context->getVersion(), '1.0.1', '<')) {
            if ($installer->getConnection()->tableColumnExists('nuvei_subscription_customer_records', 'secure_card_merchant_ref')){
                $definition = [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    'comment' => 'Secure Token Merchant Ref'
                ];
                $installer->getConnection()->modifyColumn(
                    $setup->getTable('nuvei_subscription_customer_records'),
                    'secure_card_merchant_ref',
                    $definition
                );
            }
        }

        $installer->endSetup();
    }
}