<?php
/**
 * Copyright © 2013-2017 Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Nuvei\Payment\Observer;

use Magento\Framework\Event\ObserverInterface;
use Magento\Sales\Model\Order;

class UpdateAllEditIncrementsObserver implements ObserverInterface
{
    /**
     *
     * @var \Nuvei\Payment\Helper\Data
     */
    protected $nuveiData;

    /**
     * @param \Nuvei\Payment\Helper\Data $nuveiData
     */
    public function __construct(
        \Nuvei\Payment\Helper\Data $nuveiData
    ) {
        $this->nuveiData = $nuveiData;
    }

    /**
     * Save order into registry to use it in the overloaded controller.
     *
     * @param \Magento\Framework\Event\Observer $observer
     * @return $this
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        /* @var $order Order */
        $order = $observer->getEvent()->getData('order');
        $this->nuveiData->updateOrderEditIncrements($order);

        return $this;
    }
}
