<?php
/**
 * Copyright © 2013-2017 Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Nuvei\Payment\Model\Source;

use Magento\Framework\Option\ArrayInterface;

/**
 *
 * Gateway Payment Action Dropdown source
 */
class CurrencyAction implements ArrayInterface
{
    /**
     * {@inheritdoc}
     */
    public function toOptionArray()
    {
        return [
            [
                'value' => \Nuvei\Payment\Model\Nuvei::CURRENCY_EUR,
                'label' => __('Euro')
            ],
            [
                'value' => \Nuvei\Payment\Model\Nuvei::CURRENCY_GBP,
                'label' => __('Sterling')
            ],
            [
                'value' => \Nuvei\Payment\Model\Nuvei::CURRENCY_USD,
                'label' => __('US Dollar')
            ],
            [
                'value' => \Nuvei\Payment\Model\Nuvei::CURRENCY_CAD,
                'label' => __('Canadian Dollar')
            ],
            [
                'value' => \Nuvei\Payment\Model\Nuvei::CURRENCY_AUD,
                'label' => __('Australian Dollar')
            ],
            [
                'value' => \Nuvei\Payment\Model\Nuvei::CURRENCY_DKK,
                'label' => __('Danish Krone')
            ],
            [
                'value' => \Nuvei\Payment\Model\Nuvei::CURRENCY_SEK,
                'label' => __('Swedish Krona')
            ],
            [
                'value' => \Nuvei\Payment\Model\Nuvei::CURRENCY_NOK,
                'label' => __('Norwegian Krone')
            ]
        ];
    }
}
