<?php
namespace Nuvei\Subscription\Model;

use Nuvei\Subscription\Api\Data\GridInterface;

class SubscriptionCustomer extends \Magento\Framework\Model\AbstractModel implements GridInterface
{
    /**
     * CMS page cache tag.
     */
    const CACHE_TAG = 'nuvei_subscription_customer_records';

    /**
     * @var string
     */
    protected $_cacheTag = 'nuvei_subscription_customer_records';

    /**
     * Prefix of model events names.
     *
     * @var string
     */
    protected $_eventPrefix = 'nuvei_subscription_customer_records';

    /**
     * Initialize resource model.
     */
    protected function _construct()
    {
        $this->_init('Nuvei\Subscription\Model\ResourceModel\SubscriptionCustomer');
    }
    /**
     * Get EntityId.
     *
     * @return int
     */
    public function getEntityId()
    {
        return $this->getData(self::ENTITY_ID);
    }

    /**
     * Set EntityId.
     */
    public function setEntityId($entityId)
    {
        return $this->setData(self::ENTITY_ID, $entityId);
    }

    /**
     * Get MerchantRef.
     *
     * @return varchar
     */
    public function getMerchantRef()
    {
        return $this->getData(self::MERCHANT_REF);
    }

    /**
     * Set MerchantRef.
     */
    public function setMerchantRef($merchantRef)
    {
        return $this->setData(self::MERCHANT_REF, $merchantRef);
    }

    /**
     * Get TerminalId.
     *
     * @return varchar
     */
    public function getTerminalId()
    {
        return $this->getData(self::TERMINAL_ID);
    }

    /**
     * Set TerminalId.
     */
    public function setTerminalId($terminalId)
    {
        return $this->setData(self::TERMINAL_ID, $terminalId);
    }

}