<?php
/**
 * Copyright © 2013-2017 Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Nuvei\Payment\Model\Directpost;

use Nuvei\Payment\Model\Response as NuveiResponse;
use Magento\Framework\Encryption\Helper\Security;

/**
 * Nuvei TPS response model for DirectPost model
 */
class Response extends NuveiResponse
{
    /**
     * Return if this is approved response from Nuvei TPS auth request.
     *
     * @return bool
     */
    public function isApproved()
    {
        return $this->getXResponseCode() == \Nuvei\Payment\Model\Directpost::RESPONSE_CODE_APPROVED;
    }
}
